'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Atari Signal Analysis for ROM Images Emulator Program
'
' Written using Microsoft MS-DOS QBasic Version 1.1
'
' Written by Phillip Eaton 1999-12-18
'            mailto:inbox@phillipeaton.com
'            http://www.phillipeaton.com
'            *Comments and feedback welcome & appreciated*
'
' Program Description:
'   Uses software emulation of Cyclic Redundancy Check method as implemented
'   in Atari CATBOX hardware for checking integrity of game ROM images.
'
' How to run:
'   From DOS, type QBASIC /RUN ATARICRC and press Return.
'   Whilst in QBasic, open this file and press Shift+F5.
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Version 1.0
'   Initial Release
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

' Declare Functions
DECLARE FUNCTION CRCBit& (Crc&, NewBit%)
DECLARE FUNCTION AtariHEX$ (Crc$)

' Declare Global Constants
CONST FALSE = &H0
CONST TRUE = NOT FALSE
CONST FILENUMBER% = 1

  ' Main program starts here
  CLS

  ' Get filename and bit to test from user
  INPUT "Filename of ROM image <centiped.210>"; Filename$
  IF Filename$ = "" THEN Filename$ = "centiped.210"
  INPUT "Bit number (0 to 7) <0>"; BitNumber%

  ' Open the ROM image. 'Filenumber' is used as a handle to the file.
  OPEN Filename$ FOR BINARY ACCESS READ AS FILENUMBER%

  PRINT "File Length = $"; HEX$(LOF(FILENUMBER%)); " Bytes"
  PRINT
  PRINT "Press a key to perform Signature Analysis": WHILE INKEY$ = "": WEND

  ' Loop for each of the data bytes in the file
  '   i.e. at each address of the ROM image
  FOR i% = 0 TO LOF(FILENUMBER%) - 1

    ' Read the next character in the file
    DataByteChar$ = INPUT$(1, FILENUMBER%)

    ' Convert character to an integer number
    DataByte% = ASC(DataByteChar$)

    ' Signal analysis only checks 1 bit at a time, so mask out the others
    '  and convert to a true or false
    DataBit% = (2 ^ BitNumber% AND DataByte%) <> 0

    ' Create a new CRC from old CRC and new data bit
    Crc& = CRCBit&(Crc&, DataBit%)

    PRINT "Address = $"; HEX$(i%);
    PRINT "  DataByte = "; HEX$(DataByte%);
    PRINT "  DataBit = "; DataBit%;
    PRINT "  New CRC = "; HEX$(Crc&)
  NEXT i%

  CLOSE FILENUMBER%

  PRINT "Signature = "; AtariHEX$(HEX$(Crc&));
  END

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' AtariHEX$
' Description:  Recursive procedure to convert an ASCII representation of a
'               hex number to Atari Sig Analysis format, where B,C,D,E,F are
'               replaced by C,F,H,P,U.
' Parameters:   Crc$ - ASCII representation of a hex number
' Returns:      Crc$ with [BCDEF] characters changed to [CFHPU]
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
FUNCTION AtariHEX$ (Crc$)

  ' Operation of this function is an exercise for the reader!
  IF Crc$ = "" THEN
     AtariHEX$ = Crc$
  ELSE
     SELECT CASE LEFT$(Crc$, 1)
       CASE IS = "B"
         AtariHEX$ = "C" + AtariHEX$(RIGHT$(Crc$, LEN(Crc$) - 1))
       CASE IS = "C"
         AtariHEX$ = "F" + AtariHEX$(RIGHT$(Crc$, LEN(Crc$) - 1))
       CASE IS = "D"
         AtariHEX$ = "H" + AtariHEX$(RIGHT$(Crc$, LEN(Crc$) - 1))
       CASE IS = "E"
         AtariHEX$ = "P" + AtariHEX$(RIGHT$(Crc$, LEN(Crc$) - 1))
       CASE IS = "F"
         AtariHEX$ = "U" + AtariHEX$(RIGHT$(Crc$, LEN(Crc$) - 1))
       CASE ELSE
         AtariHEX$ = LEFT$(Crc$, 1) + AtariHEX$(RIGHT$(Crc$, LEN(Crc$) - 1))
     END SELECT
  END IF

END FUNCTION

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' CRCBit&
' Description:  Update given CRC & Bit using x15 + x11 + x8 + x6 polynomial
'               Uses LONG, not INT because of left shift (see code)
' Parameters:   CRC&    - Initial 16-bit CRC
'               NewBit% - New data bit for updating CRC with
' Returns:      Updated CRC
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
FUNCTION CRCBit& (Crc&, NewBit%)

   ' Get the bits out of the initial CRC and convert to TRUE/FALSE
   Bit6% = (Crc& AND &H40) <> 0
   Bit8% = (Crc& AND &H100) <> 0
   Bit11% = (Crc& AND &H800) <> 0
   Bit15% = (Crc& AND &H8000) <> 0

   ' Left shift the original CRC
   Crc& = ((Crc& AND &H7FFF) * 2)

   ' Add feedback into left-shifted CRC
   IF (NewBit% XOR (Bit15% XOR (Bit11% XOR (Bit8% XOR Bit6%)))) THEN
      Crc& = Crc& + 1
   END IF

   ' Return the new CRC
   CRCBit& = Crc&

END FUNCTION

